<?php

require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\Artisan;

echo "<h1>Clearing Caches...</h1>";

try {
    // Clear Config Cache
    Artisan::call('config:clear');
    echo "✅ Config cache cleared.<br>";
    
    // Clear Route Cache
    Artisan::call('route:clear');
    echo "✅ Route cache cleared.<br>";
    
    // Clear Application Cache
    Artisan::call('cache:clear');
    echo "✅ Application cache cleared.<br>";
    
    // Clear View Cache
    Artisan::call('view:clear');
    echo "✅ View cache cleared.<br>";

    // Optimize (Optional, recreates cache)
    // Artisan::call('optimize');
    // echo "✅ Application optimized.<br>";

} catch (Exception $e) {
    echo "❌ Error clearing cache: " . $e->getMessage() . "<br>";
}
